



<html>
<head>
  <title>javabog.dk - Webprogrammering med Java Server Pages - Rettelser og tilf&oslash;jelser</title>
  <link rev="stylesheet" type="text/css" href="../typografi.css">
  <meta name="description" content="Lrebog i Java. Af Jacob Nordfalk. Udkommet hos Forlaget Globe">
  <meta name="keywords" content="designmnster, programmering, OOP, objekter, klasser, objektorienteret programmering, Java, JSP, lrebog, UML, IT">
</head>
<body bgcolor="#ffffff">



<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel13.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel15.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>

<H1 CLASS="western" STYLE="">14 <a name='afsn14'></a>Rettelser og
tilf&oslash;jelser</H1>
<P CLASS="western">I dette kapitel finder du rettelser og tilf&oslash;jelser
til den trykte bog (rettelserne er f&oslash;rt ind p&aring;
<A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk</A>).
Du kan udskrive kapitlet og gemme bagest i din bog.</P>
<H2 CLASS="western">14.1 <a name='afsn14.1'></a>Vigtige rettelser til 1. udgave</SPAN></H2>

<P CLASS="western">I <a href='kapitel3.jsp#afsn3.3'>afsnit 3.3</a>, Appendiks: Typer af formularfelter,
ret (tak til Klaus Elmquist Nielsen):</P>
<TABLE BORDER=1 BORDERCOLOR="#000000" CELLPADDING=4 CELLSPACING=0>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;hidden&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Skjult felt. Vises for brugeren, men alligevel
        har en v&aelig;rdi, se <a href='kapitel3.jsp#afsn3.6.2'>afsnit 3.6.2</a>, Skjulte felter i formularer.</P>
      </TD>
    </TR>
  </THEAD>
</TABLE>

<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Til:</P>
<TABLE BORDER=1 BORDERCOLOR="#000000" CELLPADDING=4 CELLSPACING=0>
  <COL*>
  <COL*>
  <THEAD>
    <TR VALIGN=TOP>
      <TD>
        <PRE CLASS="kode-western">&lt;input type=&quot;hidden&quot;&gt;</PRE>
      </TD>
      <TD>
        <P CLASS="western">Skjult felt. Vises <I>ikke for brugeren, men
        har alligevel</I> en v&aelig;rdi, se <a href='kapitel3.jsp#afsn3.6.2'>afsnit 3.6.2</a>, Skjulte felter i formularer.</P>
      </TD>
    </TR>
  </THEAD>
</TABLE>


<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">I
<SPAN LANG="da-DK">log_ind.jsp i a</SPAN>fsnit 9.5.3, Login-siden,
ret:</P>
<PRE CLASS="kode-western">&lt;font color=&quot;red&quot;&gt;
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK">if (login.isLoggetInd()) {</SPAN></PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
Til:</P>
<PRE CLASS="kode-western">&lt;font color=&quot;red&quot;&gt;
<SPAN LANG="da-DK">&lt;%</SPAN>
<SPAN LANG="da-DK"><I>login.tjekLogin();</I></SPAN>
<SPAN LANG="da-DK">if (login.isLoggetInd()) {</SPAN></PRE>

<P CLASS="western">I <SPAN LANG="da-DK">VekslerBean.java i <a href='kapitel12.jsp#afsn12.2.2'>afsnit
12.2.2</a>, Eksempel: Veksler, ret:</SPAN></P>
<PRE CLASS="kode-western">    System.out.println(&quot;<SPAN LANG="da-DK">dollarTilEuro(&quot;+dollar</SPAN>+euro+&quot;) kaldt!&quot;);</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
Til:</P>
<PRE CLASS="kode-western">    System.out.println(&quot;<SPAN LANG="da-DK">dollarTilEuro(&quot;+dollar</SPAN>+&quot;) kaldt!&quot;);</PRE>

<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">En
r&aelig;kke steder i <a href='kapitel11.jsp'>kapitel 11</a> og <a href='kapitel12.jsp'>kapitel 12</a> skal linjen</P>
<PRE CLASS="kode-western">  public double euroTilDollar(int euro)</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
i <SPAN LANG="da-DK">Veksler-klassen </SPAN>rettes til</P>
<PRE CLASS="kode-western">  public double euroTilDollar(<I>double</I> euro)</PRE>

<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">side
227, <a href='kapitel11.jsp#afsn11.7'>afsnit 11.7</a>, punkt 1 i listen:</P>
<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">XML
kr&aelig;ver at alle attributter skal v&aelig;re i &quot;..&quot;,
hvoraf</P>
<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">      
        &lt;motor hk=100 /&gt;</P>
<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">skal
v&aelig;re</P>
<P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">      
        &lt;motor hk=<I>&quot;</I>100<I>&quot;</I> /&gt;</P>

<H2 CLASS="western">14.2 <a name='afsn14.2'></a>St&oslash;rre tilf&oslash;jelser til 1.
udgave</SPAN></H2>
<P CLASS="western"><a href='kapitel3.jsp#afsn3.7.6'>Afsnit 3.7.6</a> Sende mere data til klienten l&oslash;bende
og de tre efterf&oslash;lgende afsnit.</P>
<P CLASS="western"><a href='kapitel5.jsp#afsn5.8.6'>Afsnit 5.8.6</a> Metadata og <a href='kapitel5.jsp#afsn5.8.7'>afsnit 5.8.7</a> Eksempel: Webgr&aelig;nseflade til database.</P>
<P CLASS="western"><a href='kapitel15.jsp'>Kapitel 15</a> om Java Server Faces.</P>

<DIV ID="Sektion1" HREF="../../dokumenter/jsp/jsp324.sxw&#255;&#255;4.7.6.Sende mere data til klienten l&oslash;bende|outline">
  <H3 CLASS="western">14.2.1 <a name='afsn14.2.1'></a>Sende mere data til klienten l&oslash;bende</H3>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Nogen
  gange kan en anmodning tage lang tid at fuldf&oslash;re. Det kan
  f.eks. v&aelig;re en kr&aelig;vende operation eller et indviklet
  databaseopslag. 
  </P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">I
  s&aring;danne tilf&aelig;lde vil brugeren opleve at siden tager
  utrolig lang tid at indl&aelig;se. Da er det hensigtsm&aelig;ssigt
  at sende <I>noget</I> af svaret p&aring; anmodningen, f.eks. titel
  og overskrift p&aring; siden, gerne nogle instruktioner eller
  forbehold for hvordan det efterf&oslash;lgende resultat (n&aring;r
  det kommer) skal l&aelig;ses. 
  </P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">I
  andre tilf&aelig;lde kommer der l&oslash;bende data som klienten
  skal se efterh&aring;nden som de dukker op.</P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Man
  tvinger serveren t&oslash;mme sine interne buffere og sende al data
  til klienten ved at kalde</P>
  <PRE CLASS="kode-western">  out.flush();</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  Derved sendes HTTP-hovedet<A CLASS="sdfootnoteanc" NAME="sdfootnote1anc" HREF="#sdfootnote1sym"><SUP>1</SUP></A>
  og det, der indtil videre er skrevet til out-objektet.</P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm"><BR>
  </P>
</DIV>
<DIV ID="Sektion2" HREF="../../dokumenter/jsp/jsp324.sxw&#255;&#255;4.7.7.Eksempel: Syvtabellen langsomt|outline">
  <H3 CLASS="western">14.2.2 <a name='afsn14.2.2'></a>Eksempel: Syvtabellen langsomt</H3>
  <P CLASS="western">Her er eksemplet Syvtabellen fra <a href='kapitel2.jsp#afsn2.2.1'>afsnit 2.2.1</a>
  skrevet s&aring;dan at der g&aring;r et sekund mellem hver linje:</P>
  <PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;<SPAN LANG="da-DK">Syvtabellen langsomt</SPAN>&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;p&gt;Her er syv-tabellen:&lt;br&gt;

&lt;% 
  for (int i=1; i&lt;=10; i++)
  {
    <B>out.flush()</B>;        <I>// t&oslash;m interne buffere, s&aring;dan at data sendes til klienten</I>
    Thread.sleep(1000); <I>// vent et sekund</I>
%&gt;
    Syv gange <B>&lt;%= i %&gt;</B> er: <B>&lt;%= 7*i %&gt;</B>.&lt;br&gt;
&lt;% 
  } 
%&gt;
&lt;/p&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  <BR>
  </P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm"><BR>
  </P>
</DIV>
<DIV ID="Sektion3" HREF="../../dokumenter/jsp/jsp324.sxw&#255;&#255;4.7.8.Eksempel: F&oslash;lge med i serverens logfil|outline">
  <H3 CLASS="western">14.2.3 <a name='afsn14.2.3'></a>Eksempel: F&oslash;lge med i serverens
  logfil</H3>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Det
  f&oslash;lgende eksempel f&oslash;lger med i Tomcats logfil
  (logs/catalina.out) og opdaterer hvert sekund siden med de nyeste
  oplysninger fra logfilen. 
  </P>
  <PRE CLASS="kode-western">&lt;html&gt;
&lt;head&gt;&lt;title&gt;Serverlog&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;
&lt;h1&gt;Webserverens logfil&lt;/h1&gt;
Det f&oslash;lgende er det nyeste fra webserverens logfil.&lt;br&gt;
Hvert sekund opdateres siden hvis der kommer mere i loggen, i de n&aelig;ste 10 minutter.
&lt;pre&gt;
&lt;%
  String filnavn = &quot;logs/catalina.out&quot;;<I> // sti til Tomcats logfil</I>
  long glFilLgd = 0;                    <I>// hvor mange byte filen fylder</I>
  byte[] buf = null;                    <I>// en databuffer</I>
  java.io.RandomAccessFile fil = null;  <I>// ... og selve filen</I>
 
  for (int i=0; i&lt;600; i++)             <I>// genneml&oslash;b 60 sekunder * 10 minutter</I>
  try {
    Thread.sleep(1000); <I>// vent et sekund</I>

    fil = new java.io.RandomAccessFile(filnavn,&quot;r&quot;);   <I>// &aring;bn filen</I>
    
    if (glFilLgd &lt; fil.length())                       <I>// har l&aelig;ngden &aelig;ndret sig?</I>
    {
      if (glFilLgd==0) glFilLgd = fil.length()-1500;  <I>// l&aelig;s sidste 1500 tegn</I>
      int bufLgd = (int) (fil.length() - glFilLgd);      
      if (buf==null || bufLgd &gt; buf.length) buf = new byte[bufLgd];
      fil.seek(glFilLgd);
      fil.read(buf,0,bufLgd);
      String tekst = new String(buf,0,bufLgd);
      out.println(&quot;---- lgd=&quot;+fil.length()+&quot; tid=&quot;+new java.util.Date()+&quot; ----&quot;);
      out.write(tekst);
      <B>out.flush()</B>;     <I>// t&oslash;m interne buffere, s&aring;dan at data sendes til klienten</I>
      glFilLgd = fil.length();
    }
  } finally {
    fil.close();
  }
%&gt;
&lt;/pre&gt;
Slut. &lt;br&gt;
Vil du se mere af logfilen m&aring; du genindl&aelig;se siden.
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  Bem&aelig;rk at det kan v&aelig;re en sikkerhedsrisiko at kunne
  f&oslash;lge med serverloggen (her kan ubet&aelig;nksomme
  programm&oslash;rer f.eks. komme til at logge brugernavne og
  adgangskoder som andre helst ikke skal have adgang til).</P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm"><BR>
  </P>
</DIV>
<DIV ID="Sektion4" HREF="../../dokumenter/jsp/jsp324.sxw&#255;&#255;6.8.6.Metadata|outline">
  <H3 CLASS="western">14.2.4 <a name='afsn14.2.4'></a>Metadata</H3>
  <P CLASS="western">xxx tekst ind</P>
</DIV>
<DIV ID="Sektion5" HREF="../../dokumenter/jsp/jsp324.sxw&#255;&#255;6.8.7.Eksempel: Webgr&aelig;nseflade til database |outline">
  <H3 CLASS="western">14.2.5 <a name='afsn14.2.5'></a>Eksempel: Webgr&aelig;nseflade til
  database 
  </H3>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">Under
  udviklingen af en webapplikation, der bruger en database, kan det
  v&aelig;re rart med en webbaseret gr&aelig;nseflade til databasen
  som man kan skrive SQL-kommandoer ned i eller lave foresp&oslash;rgsler
  med.</P>
  <P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm"><BR>
  </P>
  <PRE CLASS="kode-western">&lt;%@ page language=&quot;java&quot; import=&quot;java.sql.*&quot; %&gt;
&lt;html&gt;
&lt;head&gt;&lt;title&gt;Webgr&aelig;nseflade til database&lt;/title&gt;&lt;/head&gt;
&lt;body&gt;

&lt;h1&gt;SQL-gr&aelig;nseflade til databasen&lt;/h1&gt;
Herunder kan du skrive SQL-kommandoer. Adskil kommandoer med ;
&lt;form method=&quot;post&quot;&gt;
&lt;textarea name=&quot;sql&quot; rows=&quot;8&quot; cols=&quot;70&quot;&gt;SELECT * FROM kunder
&lt;/textarea&gt;
&lt;input type=&quot;submit&quot; name=&quot;udf&quot; value=&quot;Udf&oslash;r SQL!&quot;&gt;
&lt;/form&gt;

&lt;%
<I>  // Se om der kommer nogle SQL-kommander der skal behandles</I>
  String sql = request.getParameter(&quot;sql&quot;);
  Connection con = null;
  Statement stmt = null;
  if (sql != null) {
    Class.forName(&quot;com.mysql.jdbc.Driver&quot;);
    con = DriverManager.getConnection(&quot;jdbc:mysql:///test&quot;);
    stmt = con.createStatement();
    String[] kommandoer = sql.split(&quot;;&quot;); <I>// opdel i kommandoer efter skilletegn ;</I>
    for (int k=0; k&lt;kommandoer.length; k++) try {
      String kom = kommandoer[k].trim();
      if (kom.length()==0) continue; // videre til n&aelig;ste linje
      out.println(&quot;&lt;hr&gt;Udf&oslash;rer '&quot;+kom+&quot;':&lt;br&gt;&quot;);
      if (kom.toUpperCase().startsWith(&quot;SELECT&quot;)) {
        ResultSet rs = stmt.executeQuery(kom);
        ResultSetMetaData rsmd = rs.getMetaData();
        int antalKolonner = rsmd.getColumnCount();

        out.println(&quot;&lt;table border='2'&gt;&lt;tr&gt;&quot;);
        for (int i=1; i&lt;=antalKolonner; i++) 
          out.println(&quot;&lt;th&gt;&quot;+rsmd.getColumnName(i)+&quot;&lt;/th&gt;&quot;);
        out.println(&quot;&lt;/tr&gt;&quot;);
      
        // udskriv cellerne i hver r&aelig;kke
        while (rs.next())
        {
          out.println(&quot;&lt;tr&gt;&quot;);
          for (int i=1; i&lt;=antalKolonner; i++) 
            out.println(&quot;&lt;td&gt;&quot;+rs.getString(i)+&quot;&lt;/td&gt;&quot;);
          out.println(&quot;&lt;/tr&gt;&quot;);
        }
        out.println(&quot;&lt;/table&gt;&quot;);
        rs.close();
      } else {
        int ret = stmt.executeUpdate(kom);
        out.println(&quot;Returkode: &quot;+ret);
      }
    } catch (Exception e) {
      out.println(&quot;Der skete en fejl: &quot;+e);
      e.printStackTrace();
    }
    stmt.close();
    con.close();
  }
%&gt;
&lt;/body&gt;
&lt;/html&gt;</PRE><P CLASS="western" STYLE="margin-top: 0cm; margin-bottom: 0cm">
  <BR>
  </P>
</DIV>



<P ALIGN=CENTER STYLE="margin-top: 0.42cm; margin-bottom: 0.3cm; ; page-break-after: avoid">
<FONT FACE="Avant Garde, sans-serif"><FONT SIZE=7><B>Till&aelig;gskapitel
til &rdquo;Webprogrammering med JSP&rdquo;</B></FONT></FONT></P>
<P ALIGN=CENTER STYLE="margin-top: 0.42cm; margin-bottom: 0.3cm; font-style: oblique; page-break-after: avoid">
<FONT FACE="Avant Garde, sans-serif"><FONT SIZE=4 STYLE="font-size: 16pt">Jacob
Nordfalk</FONT></FONT></P>
<P CLASS="western"><A CLASS="western" HREF="http://javabog.dk/">http://javabog.dk/</A></P>

<P CLASS="western"><SDFIELD TYPE=DATETIME SDVAL="38441,5404456019" SDNUM="1030;0;DD-MM-YY">30-03-05</SDFIELD></P>

<DIV ID="sdfootnote1">
  <P CLASS="sdfootnote-western"><A CLASS="sdfootnotesym" NAME="sdfootnote1sym" HREF="#sdfootnote1anc">1</A>Og
  derved kan man s&aring; ikke mere foretage omdirigeringer, j.v.f.
  <a href='kapitel3.jsp#afsn3.7'>afsnit 3.7</a> og <a href='kapitel4.jsp#afsn4.3'>afsnit 4.3</a>.</P>
</DIV>

<a href='http://javabog.dk/'>javabog.dk</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel13.jsp'>&lt;&lt; forrige</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='indhold.jsp'>indhold</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kapitel15.jsp'>n&aelig;ste &gt;&gt;</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='kode/'>programeksempler</a>&nbsp;&nbsp;|&nbsp;&nbsp;<a href='../index_JSP.html'>om bogen</a>
<hr>
<font size=-2>http://javabog.dk/ - <b>Webprogrammering med Java Server Pages</b> af Jacob Nordfalk.
<br>
  Licens og kopiering under <a href='http://www.linuxbog.dk/licens.html'>&Aring;ben Dokumentlicens</a> (&Aring;DL)
  hvor intet andet er nvnt (72% af vrket).
</font>
<br>
nsker du at se de sidste 28% af dette vrk (275315 tegn)
skal du kbe bogen. S fr du pne figurer og layout, stikordsregister og en trykt bog med i kbet.
<!-- netlser: Wget/1.10, autoHent: true  -->
     

</body>
</html>
